<?php

namespace app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('group_id', 'name', 'notes', 'price', 'iva');

    public function group()
    {
        return $this->belongsTo('app\Models\Group', 'group_id');
    }

}